#ifndef __CLfoPanel__
#define __CLfoPanel__

#include <EGUI.h>
#include <EMusic.h>

namespace Exponent
{
	namespace SCal
	{
		/**
		 * @class CLfoPanel CLfoPanel.hpp
		 * @brief Lfo rate to hz convertor
		 *
		 * @date 18/12/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 * 
		 * $Id: CLfoPanel.hpp,v 1.3 2007/02/11 02:20:27 paul Exp $
		 */
		class CLfoPanel : public CControlPanel, public IActionListener
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param root The root control that this control is being added to
			 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
			 * @param area The area of this control relative to the root controls top left
			 * @param divisionMenu The divisions menu for the delay division
			 */
			CLfoPanel(IControlRoot *root, const long uniqueId, const CRect &area, CMenu *divisionMenu);

			/**
			 * Destruction
			 */
			virtual ~CLfoPanel();

//	===========================================================================

			/**
			 * Handle the action event
			 */
			virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * @enum EControlIds
			 * @brief Enumeration of control identifiers
			 */
			enum EControlIds
			{
				e_lfoBpmEditBox = 0,							/**< Edit box for lfo bpm */
				e_lfoDivisionComboBox,							/**< Combo box for division in lfo */
				e_lfoTimeSigNumerator,							/**< Delay Time sig numerator */
				e_lfoTimeSigDenominator,						/**< Delay Time sig denominator */
			};

//	===========================================================================

			/**
			 * Compute the lfo rate
			 */
			void computeLfoRate();

//	===========================================================================

			CTextEdit *m_lfoBpmEditBox;							/**< Edit box for lfo convertor bpm */
			CComboBox *m_lfoDivisionComboBox;					/**< Division combo box */
			CTextLabel *m_lfoOutputValueLabel;					/**< Delay output label */
			CMusicMath::ETempoDivision m_lfoDivision;			/**< division of the lfo */
		};
	}
}
#endif	// End of CLfoPanel.hpp